<?php if ( ! defined( 'FW' ) ) {
	die( 'Forbidden' );
}

$fitmeal_theme_config = fitmeal_theme_config();
$fitmeal_sections_list = fitmeal_get_sections();

$navbar_custom_assign = array();

if ( !empty( $fitmeal_theme_config['navbar'] ) AND is_array($fitmeal_theme_config['navbar']) AND sizeof( $fitmeal_theme_config['navbar']) > 1 ) {

	$menus = get_terms('nav_menu');
	if ( !empty($menus) ) {

		$list = array();
		foreach ( $menus as $item ) {

			$list[$item->term_id] = $item->name;
		}

		foreach ( $fitmeal_theme_config['navbar'] as $key => $val) {

			$navbar_custom_assign['navbar-'.$key.'-assign'] = array(
				'label' => sprintf( esc_html__( 'Navbar %s Assign', 'fitmeal' ), ucwords($key) ),
				'type'    => 'select',
				'desc' => esc_html__( 'You can assign additional menus for inner navbar.', 'fitmeal' ),
				'value' => 'default',
				'choices' => array('default' => esc_html__( 'Default', 'fitmeal' )) + $list,
			);
		}

		$navbar_custom_assign = array();
	}
}

$options = array(
	'general' => array(
		'title'   => esc_html__( 'General', 'fitmeal' ),
		'type'    => 'tab',
		'options' => array(
			'general-box' => array(
				'title'   => esc_html__( 'General Settings', 'fitmeal' ),
				'type'    => 'tab',
				'options' => array(						
					'page-loader'    => array(
						'type'    => 'multi-picker',
						'picker'       => array(
							'loader' => array(
								'label'   => esc_html__( 'Page Loader', 'fitmeal' ),
								'type'    => 'select',
								'choices' => array(
									'disabled' => esc_html__( 'Disabled', 'fitmeal' ),
									'image' => esc_html__( 'Image', 'fitmeal' ),
									'enabled' => esc_html__( 'Theme Loader', 'fitmeal' ),
								),
								'value' => 'enabled'
							)
						),						
						'choices' => array(
							'image' => array(
								'loader_img'    => array(
									'label' => esc_html__( 'Page Loader Image', 'fitmeal' ),
									'type'  => 'upload',
								),
							),
						),
						'value' => 'enabled',
					),	
					'google_api'    => array(
						'label' => esc_html__( 'Google Maps API Key', 'fitmeal' ),
						'desc'  => esc_html__( 'Required for contacts page, also used in widget. In order to use you must generate your own API on Google Maps Platform', 'fitmeal' ),
						'type'  => 'text',
					),								
				),
			),
			'logo' => array(
				'title'   => esc_html__( 'Logo and Media', 'fitmeal' ),
				'type'    => 'tab',
				'options' => array(	
					'logo-box' => array(
						'title'   => esc_html__( 'Logo', 'fitmeal' ),
						'type'    => 'box',
						'options' => array(			
							'favicon'    => array(
								'html' => esc_html__( 'To change Favicon go to Appearance -> Customize -> Site Identity', 'fitmeal' ),
								'type'  => 'html',
							),		
				            'logo_height' => array(
				                'type'  => 'slider',
				                'value' => $fitmeal_theme_config['logo_height'],
				                'properties' => array(

				                    'min' => 0,
				                    'max' => 200,
				                    'step' => 1,

				                ),
				                'label' => esc_html__('Logo Max Height, px', 'fitmeal'),
				            ),  												
							'logo'    => array(
								'label' => esc_html__( 'Logo Black', 'fitmeal' ),
								'type'  => 'upload',
							),
							'logo_2x'    => array(
								'label' => esc_html__( 'Logo Black 2x', 'fitmeal' ),
								'type'  => 'upload',
							),	
							'logo_white'    => array(
								'label' => esc_html__( 'Logo White', 'fitmeal' ),
								'type'  => 'upload',
							),
							'logo_white_2x'    => array(
								'label' => esc_html__( 'Logo White 2x', 'fitmeal' ),
								'type'  => 'upload',
							),		
							'theme-icon-main'    => array(
								'label' => esc_html__( 'Headers icon', 'fitmeal' ),
								'type'  => 'icon-v2',
							),								
							'widgets_bg'    => array(
								'label' => esc_html__( 'Sidebar Widgets Background', 'fitmeal' ),
								'type'  => 'upload',
							),									
							'404_bg'    => array(
								'label' => esc_html__( '404 Background', 'fitmeal' ),
								'type'  => 'upload',
							),	  										
						),
					),
				),
			),				
		),
	),
	'header' => array(
		'title'   => esc_html__( 'Header', 'fitmeal' ),
		'type'    => 'tab',
		'options' => array(
			'header-box-2' => array(
				'title'   => esc_html__( 'Navbar', 'fitmeal' ),
				'type'    => 'tab',
				'options' => array(
					'navbar-default'    => array(
						'label' => esc_html__( 'Navbar Default', 'fitmeal' ),
						'type'    => 'select',
						'value' => $fitmeal_theme_config['navbar-default'],
						'choices' => $fitmeal_theme_config['navbar'],
					),	
					'navbar-default-force'    => array(
						'label' => esc_html__( 'Navbar Default Override', 'fitmeal' ),
						'desc'   => esc_html__( 'By default every page can have unqiue navbar setting. You can override them here.', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'disabled' => esc_html__( 'Disabled. Every page uses its own settings', 'fitmeal' ),
							'force'  => esc_html__( 'Enabled. Override all site pages and use Navbar Default', 'fitmeal' ),
						),
						'value' => 'disabled',
					),						
					'navbar-affix'    => array(
						'label' => esc_html__( 'Navbar Sticked', 'fitmeal' ),
						'desc'   => esc_html__( 'May not work with all navbar types', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'' => esc_html__( 'Allways Static', 'fitmeal' ),
							'affix'  => esc_html__( 'Sticked', 'fitmeal' ),
						),
						'value' => '',
					),
					'navbar-breakpoint'    => array(
						'label' => esc_html__( 'Navbar Mobile Breakpoint, px', 'fitmeal' ),
						'desc'   => esc_html__( 'Mobile menu will be displayed in viewports below this value', 'fitmeal' ),
						'type'    => 'text',
						'value' => '1198',
					),												
					$navbar_custom_assign,
				)
			),
			'header-box-topbar' => array(
				'title'   => esc_html__( 'Topbar', 'fitmeal' ),
				'type'    => 'tab',
				'options' => array(
					'topbar-info'    => array(
						'label' => ' ',
						'type'    => 'html',
						'html' => esc_html__( 'You can edit topbar in sections menu of dashboard', 'fitmeal' ),
					),					
					'topbar'    => array(
						'label' => esc_html__( 'Topbar visibility', 'fitmeal' ),
						'desc'   => esc_html__( 'You can edit topbar layout in Sections menu', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'visible'  => esc_html__( 'Always Visible', 'fitmeal' ),
							'desktop'  => esc_html__( 'Desktop Visible', 'fitmeal' ),
							'desktop-tablet'  => esc_html__( 'Desktop and Tablet Visible', 'fitmeal' ),
							'mobile'  => esc_html__( 'Mobile only Visible', 'fitmeal' ),
							'hidden' => esc_html__( 'Hidden', 'fitmeal' ),
						),
						'value' => 'hidden',
					),					
					'topbar-section'    => array(
						'label' => esc_html__( 'Topbar section', 'fitmeal' ),
						'desc' => esc_html__( 'You can edit it in Sections menu of dashboard.', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array('' => 'None / Hidden') + $fitmeal_sections_list['top_bar'],						
						'value'	=> '',
					),						
				)
			),			
			'header-box-icons' => array(
				'title'   => esc_html__( 'Icons and Elements', 'fitmeal' ),
				'type'    => 'tab',
				'options' => array(		
					'icons-info'    => array(
						'label' => ' ',
						'type'    => 'html',
						'html' => esc_html__( 'Icons can be displayed in topbar using shortcode: [ltx-navbar-icons]', 'fitmeal' ),
					),																
					'navbar-icons' => array(
		                'label' => esc_html__( 'Navbar / Topbar Icons', 'fitmeal' ),
		                'desc' => esc_html__( 'Depends on theme style', 'fitmeal' ),
		                'type' => 'addable-box',
		                'value' => array(),
		                'box-options' => array(
							'type'        => array(
								'type'         => 'multi-picker',
								'label'        => false,
								'desc'         => false,
								'picker'       => array(
									'type_radio' => array(
										'label'   => esc_html__( 'Type', 'fitmeal' ),
										'type'    => 'radio',
										'choices' => array(
											'search' => esc_html__( 'Search', 'fitmeal' ),
											'basket'  => esc_html__( 'WooCommerce Cart', 'fitmeal' ),
											'profile'  => esc_html__( 'User Profile', 'fitmeal' ),
											'social'  => esc_html__( 'Social Icon', 'fitmeal' ),
										),
									)
								),
								'choices'      => array(
									'basket'  => array(
										'count'    => array(
											'label' => esc_html__( 'Count', 'fitmeal' ),
											'type'    => 'select',
											'choices' => array(
												'show' => esc_html__( 'Show count label', 'fitmeal' ),
												'hide'  => esc_html__( 'Hide count label', 'fitmeal' ),
											),
											'value' => 'show',
										),											
									),
									'profile'  => array(
					                    'header' => array(
					                        'label' => esc_html__( 'Non-logged header', 'fitmeal' ),
					                        'type' => 'text',
					                        'value' => '',
					                    ),										
									),
									'social'  => array(
					                    'text' => array(
					                        'label' => esc_html__( 'Header', 'fitmeal' ),
					                        'type' => 'text',
					                    ),
					                    'subheader' => array(
					                        'label' => esc_html__( 'Subheader', 'fitmeal' ),
					                        'type' => 'text',
					                    ),					                    
					                    'href' => array(
					                        'label' => esc_html__( 'External Link', 'fitmeal' ),
					                        'type' => 'text',
					                        'value' => '#',
					                    ),											
									),		
								),
								'show_borders' => false,
							),	  														                	
							'icon-type'        => array(
								'type'         => 'multi-picker',
								'label'        => false,
								'desc'         => false,
								'value'        => array(
									'icon_radio' => 'default',
								),
								'picker'       => array(
									'icon_radio' => array(
										'label'   => esc_html__( 'Icon', 'fitmeal' ),
										'type'    => 'radio',
										'choices' => array(
											'default'  => esc_html__( 'Default', 'fitmeal' ),
											'fa' => esc_html__( 'FontAwesome', 'fitmeal' )
										),
										'desc'    => esc_html__( 'For social icons you need to use FontAwesome in any case.',
											'fitmeal' ),
									)
								),
								'choices'      => array(
									'default'  => array(
									),
									'fa' => array(
										'icon_v2'  => array(
											'type'  => 'icon-v2',
											'label' => esc_html__( 'Select Icon', 'fitmeal' ),
										),										
									),
								),
								'show_borders' => false,
							),
							'icon-visible'        => array(
								'label'   => esc_html__( 'Visibility', 'fitmeal' ),
								'type'    => 'radio',
								'value'    => 'hidden-mob',								
								'choices' => array(
									'hidden-mob'  => esc_html__( 'Hidden on mobile', 'fitmeal' ),
									'visible-mob' => esc_html__( 'Visible on mobile', 'fitmeal' )
								),
							),							
							'profile-name'        => array(
								'label'   => esc_html__( 'Profile Name', 'fitmeal' ),
								'type'    => 'radio',
								'value'    => 'hidden',								
								'choices' => array(
									'hidden'  => esc_html__( 'Hidden', 'fitmeal' ),
									'visible' => esc_html__( 'Visible', 'fitmeal' )
								),
							),								
		                ),
                		'template' => '{{- type.type_radio }}',		                
                    ),
					'basket-icon'    => array(
						'label' => esc_html__( 'Basket icon in navbar', 'fitmeal' ),
						'desc'   => esc_html__( 'As replacement for basket in topbar in mobile view', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'disabled' => esc_html__( 'Hidden', 'fitmeal' ),
							'mobile'  => esc_html__( 'Visible on Mobile', 'fitmeal' ),
						),
						'value' => 'disabled',
					),					
				),
			),
			'header-box-1' => array(
				'title'   => esc_html__( 'Page Header H1', 'fitmeal' ),
				'type'    => 'tab',
				'options' => array(
					'pageheader-display'    => array(
						'label' => esc_html__( 'Page Header Visibility', 'fitmeal' ),
						'desc'   => esc_html__( 'Status of Page Header with H1 and Breadcrumbs', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'default' => esc_html__( 'Default', 'fitmeal' ),
							'disabled'  => esc_html__( 'Force Hidden on all Pages', 'fitmeal' ),
						),
						'value' => 'fixed',
					),		
					'pageheader-overlay'    => array(
						'label' => esc_html__( 'Page Header Overlay', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'enabled' => esc_html__( 'Enabled', 'fitmeal' ),
							'disabled'  => esc_html__( 'Disabled', 'fitmeal' ),
						),
						'value' => 'enabled',
					),	
					'header_fixed'    => array(
						'label' => esc_html__( 'Background parallax', 'fitmeal' ),
						'desc'   => esc_html__( 'Parallax effect requires large images', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'disabled' => esc_html__( 'Disabled', 'fitmeal' ),
							'fixed'  => esc_html__( 'Enabled', 'fitmeal' ),
						),
						'value' => 'fixed',
					),														
					'header_bg'    => array(
						'label' => esc_html__( 'Inner Pages Header Background', 'fitmeal' ),
						'desc'  => esc_html__( 'By default header is gray, you can replace it with background image', 'fitmeal' ),
						'type'  => 'upload',
					),  			
					'wc_bg'    => array(
						'label' => esc_html__( 'WooCommerce Header Background', 'fitmeal' ),
						'desc'  => esc_html__( 'Used only for WooCommerce pages', 'fitmeal' ),
						'type'  => 'upload',
					),  					
					'featured_bg'    => array(
						'label' => esc_html__( 'Featured Images as Background', 'fitmeal' ),
						'desc'  => esc_html__( 'Use Featured Image for Page as Header Background for all the pages', 'fitmeal' ),
						'type'    => 'select',						
						'choices' => array(
							'disabled'  => esc_html__( 'Disabled', 'fitmeal' ),
							'enabled' => esc_html__( 'Enabled', 'fitmeal' ),
						),
						'value' => 'disabled',
					),	
					'header-social'    => array(
						'label' => esc_html__( 'Social icons in page header', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'disabled'  => esc_html__( 'Disabled', 'fitmeal' ),
							'enabled' => esc_html__( 'Enabled', 'fitmeal' ),
						),
						'value' => 'enabled',
					),	

				),
			),
		),
	),	
	'footer' => array(
		'title'   => esc_html__( 'Footer', 'fitmeal' ),
		'type'    => 'tab',
		'options' => array(

			'footer-box-1' => array(
				'title'   => esc_html__( 'Widgets', 'fitmeal' ),
				'type'    => 'tab',
				'options' => array(
					'footer-layout-default'    => array(
						'label' => esc_html__( 'Footer Default Style', 'fitmeal' ),
						'type'    => 'select',
						'desc'   => esc_html__( 'Footer block before copyright. Edited in Widgets menu.', 'fitmeal' ),
						'choices' => $fitmeal_theme_config['footer'],
						'value' => $fitmeal_theme_config['footer-default'],
					),						
					'footer_widgets'    => array(
						'label' => esc_html__( 'Enable Footer Widgets', 'fitmeal' ),
						'desc'   => esc_html__( 'Widgets controled in Appearance -> Widgets. Column will be hidden, then no active widgets exists', 'fitmeal' ),	
						'type'  => 'checkbox',
						'value'	=> 'true',
					),					
					'footer-parallax'    => array(
						'label' => esc_html__( 'Footer Parallax', 'fitmeal' ),
						'type'    => 'select',							
						'choices' => array(
							'disabled'  => esc_html__( 'Disabled', 'fitmeal' ),
							'enabled' => esc_html__( 'Enabled', 'fitmeal' ),
						),
						'value' => 'disabled',
					),						
					'footer_bg'    => array(
						'label' => esc_html__( 'Footer Background', 'fitmeal' ),
						'type'  => 'upload',
					),		
					'footer-box-1-1' => array(
						'title'   => esc_html__( 'Desktop widgets visibility', 'fitmeal' ),
						'type'    => 'box',
						'options' => array(

							'footer_1_hide'    => array(
								'label' => esc_html__( 'Footer 1', 'fitmeal' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'fitmeal'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'fitmeal'),
								),						
							),
							'footer_2_hide'    => array(
								'label' => esc_html__( 'Footer 2', 'fitmeal' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'fitmeal'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'fitmeal'),
								),	
							),
							'footer_3_hide'    => array(
								'label' => esc_html__( 'Footer 3', 'fitmeal' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'fitmeal'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'fitmeal'),
								),	
							),
							'footer_4_hide'    => array(
								'label' => esc_html__( 'Footer 4', 'fitmeal' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'fitmeal'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'fitmeal'),
								),	
							),
						)
					),
					'footer-box-1-2' => array(
						'title'   => esc_html__( 'Notebook widgets visibility', 'fitmeal' ),
						'type'    => 'box',
						'options' => array(

							'footer_1__hide_md'    => array(
								'label' => esc_html__( 'Footer 1', 'fitmeal' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'fitmeal'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'fitmeal'),
								),						
							),
							'footer_2_hide_md'    => array(
								'label' => esc_html__( 'Footer 2', 'fitmeal' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'fitmeal'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'fitmeal'),
								),	
							),
							'footer_3_hide_md'    => array(
								'label' => esc_html__( 'Footer 3', 'fitmeal' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'fitmeal'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'fitmeal'),
								),	
							),
							'footer_4_hide_md'    => array(
								'label' => esc_html__( 'Footer 4', 'fitmeal' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'fitmeal'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'fitmeal'),
								),	
							),
						)
					),					
					'footer-box-1-3' => array(
						'title'   => esc_html__( 'Mobile widgets visibility', 'fitmeal' ),
						'type'    => 'box',
						'options' => array(
							'footer_1_hide_mobile'    => array(
								'label' => esc_html__( 'Footer 1', 'fitmeal' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'fitmeal'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'fitmeal'),
								),
							),
							'footer_2_hide_mobile'    => array(
								'label' => esc_html__( 'Footer 2', 'fitmeal' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'fitmeal'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'fitmeal'),
								),
							),
							'footer_3_hide_mobile'    => array(
								'label' => esc_html__( 'Footer 3', 'fitmeal' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'fitmeal'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'fitmeal'),
								),
							),
							'footer_4_hide_mobile'    => array(
								'label' => esc_html__( 'Footer 4', 'fitmeal' ),
								'type'  => 'switch',
								'value'	=> 'show',
								'left-choice' => array(
									'value' => 'hide',
									'label' => esc_html__('Hide', 'fitmeal'),
								),
								'right-choice' => array(
									'value' => 'show',
									'label' => esc_html__('Show', 'fitmeal'),
								),
							),														
						)
					)
				),
			),
			'footer-box-subscribe' => array(
				'title'   => esc_html__( 'Subscribe and Other', 'fitmeal' ),
				'type'    => 'tab',
				'options' => array(
					'footer-sections'    => array(
						'html' => esc_html__( 'You can edit all items in Sections menu of dashboard.', 'fitmeal' ),
						'type'  => 'html',
					),							
					'subscribe-section'    => array(
						'label' => esc_html__( 'Subscribe block', 'fitmeal' ),
						'desc' => esc_html__( 'Section displayed before widgets on every page. You can hide in on certain page in page settings.', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array('' => 'None / Hidden') + $fitmeal_sections_list['subscribe'],						
						'value'	=> '',
					),
					'before-footer-section'    => array(
						'label' => esc_html__( 'Before Footer section', 'fitmeal' ),
						'desc' => esc_html__( 'Section displayed under all content before subscribe/widgets.', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array('' => 'None / Hidden') + $fitmeal_sections_list['before_footer'],
						'value'	=> '',
					),					
				),
			),	
			'footer-box-2' => array(
				'title'   => esc_html__( 'Go Top', 'fitmeal' ),
				'type'    => 'tab',
				'options' => array(															
					'go_top_visibility'    => array(
						'label' => esc_html__( 'Go Top Visibility', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'visible'  => esc_html__( 'Always visible', 'fitmeal' ),
							'desktop' => esc_html__( 'Desktop Only', 'fitmeal' ),
							'mobile' => esc_html__( 'Mobile Only', 'fitmeal' ),
							'hidden' => esc_html__( 'Hidden', 'fitmeal' ),
						),						
						'value'	=> 'visible',
					),		
					'go_top_pos'    => array(
						'label' => esc_html__( 'Go Top Position', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'floating'  => esc_html__( 'Floating', 'fitmeal' ),
							'static' => esc_html__( 'Static at the footer', 'fitmeal' ),
						),						
						'value'	=> 'floating',
					),		
					'go_top_img'    => array(
						'label' => esc_html__( 'Go Top Image', 'fitmeal' ),
						'type'  => 'upload',
					),		
					'go_top_icon'    => array(
						'label' => esc_html__( 'Go Top Icon', 'fitmeal' ),
						'type'  => 'icon-v2',
					),					
					'go_top_text'    => array(
						'label' => esc_html__( 'Go Top Text', 'fitmeal' ),
						'type'  => 'text',
					),														
				),
			),
			'footer-box-3' => array(
				'title'   => esc_html__( 'Copyrights', 'fitmeal' ),
				'type'    => 'tab',
				'options' => array(																							
					'copyrights'    => array(
						'label' => esc_html__( 'Copyrights', 'fitmeal' ),
						'type'  => 'wp-editor',
					),									
				),
			),					
		),
	),	
	'layout' => array(
		'title'   => esc_html__( 'Posts Layout', 'fitmeal' ),
		'type'    => 'tab',
		'options' => array(

			'layout-box-1' => array(
				'title'   => esc_html__( 'Blog Posts', 'fitmeal' ),
				'type'    => 'tab',
				'options' => array(

					'blog_layout'    => array(
						'label' => esc_html__( 'Blog Layout', 'fitmeal' ),
						'desc'   => esc_html__( 'Default blog page layout.', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'classic'  => esc_html__( 'One Column', 'fitmeal' ),
							'two-cols' => esc_html__( 'Two Columns', 'fitmeal' ),
							'three-cols' => esc_html__( 'Three Columns', 'fitmeal' ),
						),
						'value' => 'classic',
					),				
					'blog_list_sidebar'    => array(
						'label' => esc_html__( 'Blog List Sidebar', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'hidden'  => esc_html__( 'Hidden', 'fitmeal' ),
							'left' => esc_html__( 'Left', 'fitmeal' ),
							'right' => esc_html__( 'Right', 'fitmeal' ),
						),
						'value' => 'right',
					),				
					'blog_post_sidebar'    => array(
						'label' => esc_html__( 'Blog Post Sidebar', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'hidden'  => esc_html__( 'Hidden', 'fitmeal' ),
							'left' => esc_html__( 'Left', 'fitmeal' ),
							'right' => esc_html__( 'Right', 'fitmeal' ),
						),
						'value' => 'right',
					),																				
					'excerpt_auto'    => array(
						'label' => esc_html__( 'Excerpt Classic Blog Size', 'fitmeal' ),
						'desc'  => esc_html__( 'Automaticly cuts content for blogs', 'fitmeal' ),
						'value'	=> 350,
						'type'  => 'short-text',
					),
					'excerpt_masonry_auto'    => array(
						'label' => esc_html__( 'Excerpt Masonry Blog Size', 'fitmeal' ),
						'desc'  => esc_html__( 'Automaticly cuts content for blogs', 'fitmeal' ),
						'value'	=> 150,
						'type'  => 'short-text',
					),
					'blog_gallery_autoplay'    => array(
						'label' => esc_html__( 'Gallery post type autoplay, ms', 'fitmeal' ),
						'desc'  => esc_html__( 'Set 0 to disable autoplay', 'fitmeal' ),
						'type'  => 'text',
						'value' => '4000',
					),						
				)
			),
			'layout-box-2' => array(
				'title'   => esc_html__( 'Services', 'fitmeal' ),
				'type'    => 'tab',
				'options' => array(	
					'services_list_layout'    => array(
						'label' => esc_html__( 'Services List Layout', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'classic'  => esc_html__( 'One Column', 'fitmeal' ),
							'two-cols' => esc_html__( 'Two Columns', 'fitmeal' ),
							'three-cols' => esc_html__( 'Three Columns', 'fitmeal' ),
						),
						'value' => 'two-cols',
					),						
					'services_list_sidebar'    => array(
						'label' => esc_html__( 'Services List Sidebar', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'hidden'  => esc_html__( 'Hidden', 'fitmeal' ),
							'left' => esc_html__( 'Left', 'fitmeal' ),
							'right' => esc_html__( 'Right', 'fitmeal' ),
						),
						'value' => 'hidden',
					),				
					'services_post_sidebar'    => array(
						'label' => esc_html__( 'Services Post Sidebar', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'hidden'  => esc_html__( 'Hidden', 'fitmeal' ),
							'left' => esc_html__( 'Left', 'fitmeal' ),
							'right' => esc_html__( 'Right', 'fitmeal' ),
						),
						'value' => 'hidden',
					),					
				)
			),
			'layout-box-3' => array(
				'title'   => esc_html__( 'WooCommerce', 'fitmeal' ),
				'type'    => 'tab',
				'options' => array(
					'shop_list_sidebar'    => array(
						'label' => esc_html__( 'WooCommerce List Sidebar', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'hidden'  => esc_html__( 'Hidden', 'fitmeal' ),
							'left' => esc_html__( 'Left', 'fitmeal' ),
							'right' => esc_html__( 'Right', 'fitmeal' ),
						),
						'value' => 'left',
					),				
					'shop_post_sidebar'    => array(
						'label' => esc_html__( 'WooCommerce Product Sidebar', 'fitmeal' ),
						'desc'   => esc_html__( 'Blog Post Sidebar', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'hidden'  => esc_html__( 'Hidden', 'fitmeal' ),
							'left' => esc_html__( 'Left', 'fitmeal' ),
							'right' => esc_html__( 'Right', 'fitmeal' ),
						),
						'value' => 'hidden',
					),											
					'excerpt_wc_auto'    => array(
						'label' => esc_html__( 'Excerpt WooCommerce Size', 'fitmeal' ),
						'desc'  => esc_html__( 'Automaticly cuts description for products', 'fitmeal' ),
						'value'	=> 50,
						'type'  => 'short-text',
					),		
					'wc_zoom'    => array(
						'label' => esc_html__( 'WooCommerce Product Hover Zoom', 'fitmeal' ),
						'type'    => 'select',
						'desc'   => esc_html__( 'Enables mouse hover zoom in single product page', 'fitmeal' ),
						'choices' => array(
							'disabled'  => esc_html__( 'Disabled', 'fitmeal' ),
							'enabled' => esc_html__( 'Enabled', 'fitmeal' ),
						),
						'value' => 'disabled',
					),
					'wc_hover_gallery'    => array(
						'label' => esc_html__( 'Hover Gallery Photo ', 'fitmeal' ),
						'type'    => 'select',
						'desc'   => esc_html__( 'Display first gallery image on product list hover', 'fitmeal' ),
						'choices' => array(
							'disabled'  => esc_html__( 'Disabled', 'fitmeal' ),
							'enabled' => esc_html__( 'Enabled', 'fitmeal' ),
						),
						'value' => 'disabled',
					),							
					'wc_columns'    => array(
						'label' => esc_html__( 'Columns number', 'fitmeal' ),
						'desc'  => esc_html__( 'Overrides default WooCommerce settings', 'fitmeal' ),
						'type'  => 'text',
						'value' => '3',
					),
					'wc_per_page'    => array(
						'label' => esc_html__( 'Products per Page', 'fitmeal' ),
						'type'  => 'text',
						'value' => '6',
					),
					'wc_show_list_excerpt'    => array(
						'label' => esc_html__( 'Display Excerpt in Shop List', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'disabled'  => esc_html__( 'Disabled', 'fitmeal' ),
							'enabled' => esc_html__( 'Enabled', 'fitmeal' ),
						),
						'value' => 'enabled',
					),					
					'wc_show_list_rate'    => array(
						'label' => esc_html__( 'Display Rate in Shop List', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'disabled'  => esc_html__( 'Disabled', 'fitmeal' ),
							'enabled' => esc_html__( 'Enabled', 'fitmeal' ),
						),
						'value' => 'disabled',
					),
					'wc_show_list_attr'    => array(
						'label' => esc_html__( 'Display Attributes in Shop List', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'disabled'  => esc_html__( 'Disabled', 'fitmeal' ),
							'enabled' => esc_html__( 'Enabled', 'fitmeal' ),
						),
						'value' => 'disabled',
					),
					'wc_show_more'    => array(
						'label' => esc_html__( 'Display Read More', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'disabled'  => esc_html__( 'Disabled', 'fitmeal' ),
							'enabled' => esc_html__( 'Enabled', 'fitmeal' ),
						),
						'value' => 'disabled',
					),					
					'wc_new_days'    => array(
						'label' => esc_html__( 'Number of days to display New label. Set 0 to hide.', 'fitmeal' ),
						'type'  => 'text',
						'value' => '30',
					),						
				)
			),
			'layout-box-4' => array(
				'title'   => esc_html__( 'Gallery', 'fitmeal' ),
				'type'    => 'tab',
				'options' => array(													
					'gallery_layout'    => array(
						'label' => esc_html__( 'Default Gallery Layout', 'fitmeal' ),
						'desc'   => esc_html__( 'Default galley page layout.', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'col-2' => esc_html__( 'Two Columns', 'fitmeal' ),
							'col-3' => esc_html__( 'Three Columns', 'fitmeal' ),
							'col-4' => esc_html__( 'Four Columns', 'fitmeal' ),
						),
						'value' => 'col-2',
					),						
				)
			)
		)
	),
	'fonts' => array(
		'title'   => esc_html__( 'Fonts', 'fitmeal' ),
		'type'    => 'tab',
		'options' => array(

			'fonts-box' => array(
				'title'   => esc_html__( 'Fonts Settings', 'fitmeal' ),
				'type'    => 'tab',
				'options' => array(
					'font-main'                => array(
						'label' => __( 'Main Font', 'fitmeal' ),
						'type'  => 'typography-v2',
						'desc'	=>	esc_html__( 'Use https://fonts.google.com/ to find font you need', 'fitmeal' ),
						'value'      => array(
							'family'    => $fitmeal_theme_config['font_main'],
							'subset'    => 'latin-ext',
							'variation' => $fitmeal_theme_config['font_main_var'],
							'size'      => 0,
							'line-height' => 0,
							'letter-spacing' => 0,
							'color'     => '#000'
						),
						'components' => array(
							'family'         => true,
							'size'           => false,
							'line-height'    => false,
							'letter-spacing' => false,
							'color'          => false
						),
					),
					'font-main-weights'    => array(
						'label' => esc_html__( 'Additonal weights', 'fitmeal' ),
						'desc'  => esc_html__( 'Coma separates weights, for example: "800,900"', 'fitmeal' ),
						'type'  => 'text',
						'value'  => $fitmeal_theme_config['font_main_weights'],							
					),											
					'font-headers'                => array(
						'label' => __( 'Headers Font', 'fitmeal' ),
						'type'  => 'typography-v2',
						'value'      => array(
							'family'    => $fitmeal_theme_config['font_headers'],
							'subset'    => 'latin-ext',
							'variation' => $fitmeal_theme_config['font_headers_var'],
							'size'      => 0,
							'line-height' => 0,
							'letter-spacing' => 0,
							'color'     => '#000'
						),
						'components' => array(
							'family'         => true,
							'size'           => false,
							'line-height'    => false,
							'letter-spacing' => false,
							'color'          => false
						),
					),
					'font-headers-weights'    => array(
						'label' => esc_html__( 'Additonal weights', 'fitmeal' ),
						'desc'  => esc_html__( 'Coma separates weights, for example: "600,800"', 'fitmeal' ),
						'type'  => 'text',
						'value'  => $fitmeal_theme_config['font_headers_weights'],						
					),
					'font-subheaders'                => array(
						'label' => __( 'SubHeaders Font', 'fitmeal' ),
						'type'  => 'typography-v2',
						'value'      => array(
							'family'    => $fitmeal_theme_config['font_subheaders'],
							'subset'    => 'latin-ext',
							'variation' => $fitmeal_theme_config['font_subheaders_var'],
							'size'      => 0,
							'line-height' => 0,
							'letter-spacing' => 0,
							'color'     => '#000'
						),
						'components' => array(
							'family'         => true,
							'size'           => false,
							'line-height'    => false,
							'letter-spacing' => false,
							'color'          => false
						),
					),
					'font-subheaders-weights'    => array(
						'label' => esc_html__( 'Additonal weights', 'fitmeal' ),
						'desc'  => esc_html__( 'Coma separates weights, for example: "600,800"', 'fitmeal' ),
						'type'  => 'text',
						'value'  => $fitmeal_theme_config['font_subheaders_weights'],						
					),							
				),
			),
			'fontello-box' => array(
				'title'   => esc_html__( 'Fontello', 'fitmeal' ),
				'type'    => 'tab',
				'options' => array(
					'fontello-css'    => array(
						'label' => esc_html__( 'Fontello Codes CSS', 'fitmeal' ),
						'desc'  => esc_html__( 'Upload *-codes.css postfix file here', 'fitmeal' ),
						'type'  => 'upload',
						'images_only' => false,
					),		
					'fontello-ttf'    => array(
						'label' => esc_html__( 'Fontello TTF', 'fitmeal' ),
						'type'  => 'upload',
						'images_only' => false,
					),							
					'fontello-eot'    => array(
						'label' => esc_html__( 'Fontello EOT', 'fitmeal' ),
						'type'  => 'upload',
						'images_only' => false,
					),							
					'fontello-woff'    => array(
						'label' => esc_html__( 'Fontello WOFF', 'fitmeal' ),
						'type'  => 'upload',
						'images_only' => false,
					),							
					'fontello-woff2'    => array(
						'label' => esc_html__( 'Fontello WOFF2', 'fitmeal' ),
						'type'  => 'upload',
						'images_only' => false,
					),							
					'fontello-svg'    => array(
						'label' => esc_html__( 'Fontello SVG', 'fitmeal' ),
						'type'  => 'upload',
						'images_only' => false,
					),												
				),
			),

		),
	),	
	'social' => array(
		'title'   => esc_html__( 'Social', 'fitmeal' ),
		'type'    => 'tab',
		'options' => array(
			'social-box' => array(
				'title'   => esc_html__( 'Social', 'fitmeal' ),
				'type'    => 'tab',
				'options' => array(
					'target-social'    => array(
						'label' => esc_html__( 'Open social links in', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'self'  => esc_html__( 'Same window', 'fitmeal' ),
							'blank' => esc_html__( 'New window', 'fitmeal' ),
						),
						'value' => 'self',
					),															
		            'social-icons' => array(
		                'label' => esc_html__( 'Social Icons', 'fitmeal' ),
		                'type' => 'addable-box',
		                'value' => array(),
		                'desc' => esc_html__( 'Visible in inner page header', 'fitmeal' ),
		                'box-options' => array(
		                    'icon_v2' => array(
		                        'label' => esc_html__( 'Icon', 'fitmeal' ),
		                        'type'  => 'icon-v2',
		                    ),
		                    'text' => array(
		                        'label' => esc_html__( 'Text', 'fitmeal' ),
		                        'desc' => esc_html__( 'If needed', 'fitmeal' ),
		                        'type' => 'text',
		                    ),
		                    'href' => array(
		                        'label' => esc_html__( 'Link', 'fitmeal' ),
		                        'type' => 'text',
		                        'value' => '#',
		                    ),		                    
		                ),
                		'template' => '{{- text }}',		                
                    ),								
				),
			),
		),
	),	
	'colors' => array(
		'title'   => esc_html__( 'Colors Schemes', 'fitmeal' ),
		'type'    => 'tab',
		'options' => array(			
			'schemes-box' => array(
				'title'   => esc_html__( 'Additional Color Schemes Settings', 'fitmeal' ),
				'type'    => 'box',
				'options' => array(
					'advice'    => array(
						'html' => esc_html__( 'You also need to change the global settings in Appearance -> Customize -> Fitmeal settings', 'fitmeal' ),
						'type'  => 'html',
					),	
					'items' => array(
						'label' => esc_html__( 'Theme Color Schemes', 'fitmeal' ),
						'type' => 'addable-box',
						'value' => array(),
						'desc' => esc_html__( 'Can be selected in page settings', 'fitmeal' ),
						'box-options' => array(
							'slug' => array(
								'label' => esc_html__( 'Scheme ID', 'fitmeal' ),
								'type' => 'text',
								'desc' => esc_html__( 'Required Field', 'fitmeal' ),
								'value' => '',
							),							
							'name' => array(
								'label' => esc_html__( 'Scheme Name', 'fitmeal' ),
								'desc' => esc_html__( 'Required Field', 'fitmeal' ),
								'type' => 'text',
								'value' => '',
							),
							'logo'    => array(
								'label' => esc_html__( 'Logo White', 'fitmeal' ),
								'type'  => 'upload',
							),
							'logo_2x'    => array(
								'label' => esc_html__( 'Logo White 2x', 'fitmeal' ),
								'type'  => 'upload',
							),
							'logo_white'    => array(
								'label' => esc_html__( 'Logo Black', 'fitmeal' ),
								'type'  => 'upload',
							),		
							'logo_white_2x'    => array(
								'label' => esc_html__( 'Logo Black 2x', 'fitmeal' ),
								'type'  => 'upload',
							),		
							'main-color'  => array(
								'label' => esc_html__( 'Main Color', 'fitmeal' ),
								'type'  => 'color-picker',
							),
							'second-color' => array(
								'label' => esc_html__( 'Second Color', 'fitmeal' ),
								'type'  => 'color-picker',
							),
							'gray-color' => array(
								'label' => esc_html__( 'Gray Color', 'fitmeal' ),
								'type'  => 'color-picker',
							),								
							'black-color' => array(
								'label' => esc_html__( 'Black Color', 'fitmeal' ),
								'type'  => 'color-picker',
							),	
							'white-color' => array(
								'label' => esc_html__( 'White Color', 'fitmeal' ),
								'type'  => 'color-picker',
							),								
						),
						'template' => '{{- name }}',
					),
				),
			),
		),
	),	
	'popup' => array(
		'title'   => esc_html__( 'Popup', 'fitmeal' ),
		'type'    => 'tab',
		'options' => array(
			'popup-box' => array(
				'title'   => esc_html__( 'Popup settings', 'fitmeal' ),
				'type'    => 'box',
				'options' => array(						
					'popup-status'    => array(
						'label'   => esc_html__( 'Status', 'fitmeal' ),
						'type'    => 'select',
						'choices' => array(
							'disabled' => esc_html__( 'Disabled', 'fitmeal' ),
							'enabled'  => esc_html__( 'Enabled', 'fitmeal' ),
						),
						'value' => 'disabled'
					),						
					'popup-hours'    => array(
						'label' => esc_html__( 'Period hidden, days', 'fitmeal' ),
						'type'  => 'text',
						'value'	=>	'24',
					),						
					'popup-text'    => array(
						'label' => esc_html__( 'Popup text', 'fitmeal' ),
						'type'  => 'wp-editor',
					),
					'popup-bg'    => array(
						'label' => esc_html__( 'Popup Background', 'fitmeal' ),
						'type'  => 'upload',
					),					
					'popup-yes'    => array(
						'label' => esc_html__( 'Yes button', 'fitmeal' ),
						'type'  => 'text',
						'value'	=>	'Yes',
					),	
					'popup-no'    => array(
						'label' => esc_html__( 'No button', 'fitmeal' ),
						'type'  => 'text',
						'value'	=>	'No',
					),																
					'popup-no-link'    => array(
						'label' => esc_html__( 'No link', 'fitmeal' ),
						'type'  => 'text',
						'value'	=>	'https://google.com',
					),																
				),	
			),
		),
	),
);

unset($options['popup']);
unset($options['header']['header-box-topbar']);

if ( function_exists('ltx_share_buttons_conf') ) {

	$share_links = ltx_share_buttons_conf();

	$share_links_options = array();
	if ( !empty($share_links) ) {

		$share_links_options = array(

			'share_icons_hide' => array(
                'label' => esc_html__( 'Hide all share icons block', 'fitmeal' ),
                'type'  => 'checkbox',
                'value'	=>	false,
            ),
		);
		foreach ( $share_links as $key => $item ) {

			$state = fw_get_db_settings_option( 'share_icon_' . $key );

			$value = false;
			if ( is_null($state) AND $item['active'] == 1 ) {

				$value = true;
			}

			$share_links_options[] =
			array(
				'share_icon_'.$key => array(
	                'label' => $item['header'],
	                'type'  => 'checkbox',
	                'value'	=>	$value,
	            ),
			);
		}
	}

	$share_links_options['share-add'] = array(

        'label' => esc_html__( 'Custom Share Buttons', 'fitmeal' ),
        'type' => 'addable-box',
        'value' => array(),
        'desc' => esc_html__( 'You can use {link} and {title} variables to set url. E.g. "http://www.facebook.com/sharer.php?u={link}"', 'fitmeal' ),
        'box-options' => array(
            'icon' => array(
                'label' => esc_html__( 'Icon', 'fitmeal' ),
                'type'  => 'icon-v2',
            ),
            'header' => array(
                'label' => esc_html__( 'Header', 'fitmeal' ),
                'type' => 'text',
            ),
            'link' => array(
                'label' => esc_html__( 'Link', 'fitmeal' ),
                'type' => 'text',
                'value' => '',
            ),		  
            'color' => array(
                'label' => esc_html__( 'Color', 'fitmeal' ),
                'type' => 'color-picker',
                'value' => '',
            ),		              
        ),
		'template' => '{{- header }}',		                
    );

	$options['social']['options']['share-box'] = array(
		'title'   => esc_html__( 'Share Buttons', 'fitmeal' ),
		'type'    => 'tab',
		'options' => $share_links_options,
	);
}

