<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }
/**
 * Theme Configuration and Custom CSS initializtion
 */

/**
 * Global theme config for header/footer/sections/colors/fonts
 */
if ( !function_exists('fitmeal_theme_config') ) {

	add_filter( 'ltx_get_theme_config', 'fitmeal_theme_config', 10, 1 );
	function fitmeal_theme_config() {

	    return array(
	    	'navbar'	=>	array(
				'white'  	=> esc_html__( 'White Background', 'fitmeal' ),
				'hamburger'  => esc_html__( 'Desktop with Hamburger', 'fitmeal' ),
			),
			'navbar-default' => 'white',

			'footer' => array(
				'default'  => esc_html__( 'Default', 'fitmeal' ),		
				'copyright'  => esc_html__( 'Copyright Only', 'fitmeal' ),
				'copyright-transparent'  => esc_html__( 'Copyright Transparent', 'fitmeal' ),						
			),
			'footer-default' => 'default',

			'color_main'	=>	'#8EC038',
			'color_second'	=>	'#DA2424',
			'color_black'	=>	'#292D35',
			'color_gray'	=>	'#F3F5ED',
			'color_white'	=>	'#FFFFFF',
			'color_red'		=>	'#DA2424',
			'color_main_header'	=>	esc_html__( 'Green', 'fitmeal' ),

			'logo_height'		=>	41,
			'navbar_dark'		=>	'rgba(0,0,0,0.75)',

			'font_main'					=>	'Open Sans',
			'font_main_var'				=>	'regular',
			'font_main_weights'			=>	'400,400i,700',
			'font_headers'				=>	'Fira Sans',
			'font_headers_var'			=>	'regular',
			'font_headers_weights'		=>	'700',
			'font_subheaders'			=>	'Sacramento',
			'font_subheaders_var'		=>	'regular',
			'font_subheaders_weights'	=>	'',
		);
	}
}

/**
 *  Editor Settings
 */
function fitmeal_editor_settings() {

	$cfg = fitmeal_theme_config();

    add_theme_support( 'editor-color-palette', array(
        array(
            'name' => esc_html__( 'Main', 'fitmeal' ),
            'slug' => 'main-theme',
            'color' => $cfg['color_main'],
        ),
        array(
            'name' => esc_html__( 'Gray', 'fitmeal' ),
            'slug' => 'gray',
            'color' => $cfg['color_gray'],
        ),
        array(
            'name' => esc_html__( 'Black', 'fitmeal' ),
            'slug' => 'black',
            'color' => $cfg['color_black'],
        ),
        array(
            'name' => esc_html__( 'Red', 'fitmeal' ),
            'slug' => 'red',
            'color' => $cfg['color_red'],
        ),        
    ) );

	add_theme_support( 'editor-font-sizes', array(
		array(
			'name'      => esc_html__( 'small', 'fitmeal' ),
			'shortName' => esc_html__( 'S', 'fitmeal' ),
			'size'      => 14,
			'slug'      => 'small'
		),
		array(
			'name'      => esc_html__( 'regular', 'fitmeal' ),
			'shortName' => esc_html__( 'M', 'fitmeal' ),
			'size'      => 16,
			'slug'      => 'regular'
		),
		array(
			'name'      => esc_html__( 'large', 'fitmeal' ),
			'shortName' => esc_html__( 'L', 'fitmeal' ),
			'size'      => 24,
			'slug'      => 'large'
		),
	) );    
}
add_action( 'after_setup_theme', 'fitmeal_editor_settings', 10 );

/**
 * Get Google default font url
 */
if ( !function_exists('fitmeal_font_url') ) {

	function fitmeal_font_url() {

		$cfg = fitmeal_theme_config();
		$q = array();
		foreach ( array('font_main', 'font_headers', 'font_subheaders') as $item ) {

			if ( !empty($cfg[$item]) ) {

				$w = '';
				if ( !empty($cfg[$item.'_weights']) ) {

					$w .= ':'.$cfg[$item.'_weights'];
				}
				$q[] = $cfg[$item].$w;
			}
		}

		$query_args = array( 'family' => implode('|', $q), 'subset' => 'latin' );

		$font_url = add_query_arg( $query_args, '//fonts.googleapis.com/css' );

		return esc_url( $font_url );
	}
}

/**
 * Config used for lt-ext plugin to set Visual Composer configuration
 */
if ( !function_exists('fitmeal_vc_config') ) {

	add_filter( 'ltx_get_vc_config', 'fitmeal_vc_config', 10, 1 );
	function fitmeal_vc_config( $value ) {

	    return array(
	    	'sections'	=>	array(
				esc_html__("Overflow visible section", 'fitmeal') 	=> "displaced-top",				
			),
			'background' => array(
				esc_html__( "Main", 'fitmeal' ) => "theme_color",	
				esc_html__( "Second", 'fitmeal' ) => "second",	
				esc_html__( "Gray", 'fitmeal' ) => "gray",
				esc_html__( "White", 'fitmeal' ) => "white",
				esc_html__( "Black", 'fitmeal' ) => "black",			
			),
			'overlay'	=> array(
				esc_html__( "Black Overlay (50%)", 'fitmeal' ) => "black",
				esc_html__( "Dark Overlay (40%)", 'fitmeal' ) => "dark",
				esc_html__( "Light Overlay (20%)", 'fitmeal' ) => "white",
				esc_html__( "Gray Waves", 'fitmeal' ) => "gray-waves",
				esc_html__( "White Waves", 'fitmeal' ) => "white-waves",
				esc_html__( "Black Waves", 'fitmeal' ) => "black-waves",
				esc_html__( "Main Color Waves", 'fitmeal' ) => "main-waves",
				esc_html__( "Second Color Waves", 'fitmeal' ) => "second-waves",
			),
		);
	}
}


/*
* Adding additional TinyMCE options
*/
if ( !function_exists('fitmeal_mce_before_init_insert_formats') ) {

	add_filter('mce_buttons_2', 'fitmeal_wpb_mce_buttons_2');
	function fitmeal_wpb_mce_buttons_2( $buttons ) {

	    array_unshift($buttons, 'styleselect');
	    return $buttons;
	}

	add_filter( 'tiny_mce_before_init', 'fitmeal_mce_before_init_insert_formats' );
	function fitmeal_mce_before_init_insert_formats( $init_array ) {  

	    $style_formats = array(

	        array(  
	            'title' => esc_html__('Main Color', 'fitmeal'),
	            'block' => 'span',  
	            'classes' => 'color-main',
	            //'wrapper' => true,
	        ),  
	        array(  
	            'title' => esc_html__('White Color', 'fitmeal'),
	            'block' => 'span',  
	            'classes' => 'color-white',
	            'wrapper' => true,   
	        ),
	        array(  
	            'title' => esc_html__('Medium Text', 'fitmeal'),
	            'block' => 'span',  
	            'classes' => 'text-md',
	            'wrapper' => true,
	        ),    	        
	        array(  
	            'title' => esc_html__('Large Text', 'fitmeal'),
	            'block' => 'span',  
	            'classes' => 'text-lg',
	            'wrapper' => true,
	        ),    
	        array(  
	            'title' => 'List Checkbox',
	            'selector' => 'ul',
	            'classes' => 'check',
	        ),     
	        array(  
	            'title' => 'List Checkbox Inverted',
	            'selector' => 'ul',
	            'classes' => 'check-invert',
	        ),     	        
	        array(  
	            'title' => 'List Bullets',
	            'selector' => 'ul',
	            'classes' => 'disc',
	        ),     	        
	        array(  
	            'title' => 'Multi-Column List',
	            'selector' => 'ul',
	            'classes' => 'multicol',
	        ),	          
	    );  
	    $init_array['style_formats'] = json_encode( $style_formats );  
	     
	    return $init_array;  
	} 
}


/**
 * Register widget areas.
 *
 */
if ( !function_exists('fitmeal_action_theme_widgets_init') ) {

	add_action( 'widgets_init', 'fitmeal_action_theme_widgets_init' );
	function fitmeal_action_theme_widgets_init() {

		$span_class = 'widget-icon';

		$header_class = $theme_icon = '';
		if ( function_exists('FW') ) {

			if ( !empty($theme_icon['icon-class']) ) $header_class = 'hasIcon';
		}


		register_sidebar( array(
			'name'          => esc_html__( 'Sidebar Default', 'fitmeal' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Displayed in the right/left section of the site.', 'fitmeal' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="header-widget '.esc_attr($header_class).'"><span class="'.esc_attr($span_class).'"></span>',
			'after_title'   => '<span class="last '.esc_attr($span_class).'"></span></h3>',
		) );

		register_sidebar( array(
			'name'          => esc_html__( 'Sidebar WooCommerce', 'fitmeal' ),
			'id'            => 'sidebar-wc',
			'description'   => esc_html__( 'Displayed in the right/left section of the site.', 'fitmeal' ),
			'before_widget' => '<aside id="%1$s" class="widget %2$s">',
			'after_widget'  => '</aside>',
			'before_title'  => '<h3 class="header-widget '.esc_attr($header_class).'"><span class="'.esc_attr($span_class).'"></span>',
			'after_title'   => '<span class="last '.esc_attr($span_class).'"></span></h3>',
		) );

		register_sidebar( array(
			'name'          => esc_html__( 'Footer 1', 'fitmeal' ),
			'id'            => 'footer-1',
			'description'   => esc_html__( 'Displayed in the footer section of the site.', 'fitmeal' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="header-widget '.esc_attr($header_class).'"><span class="'.esc_attr($span_class).'"></span>',
			'after_title'   => '<span class="last '.esc_attr($span_class).'"></span></h3>',
		) );			

		register_sidebar( array(
			'name'          => esc_html__( 'Footer 2', 'fitmeal' ),
			'id'            => 'footer-2',
			'description'   => esc_html__( 'Displayed in the footer section of the site.', 'fitmeal' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="header-widget '.esc_attr($header_class).'"><span class="'.esc_attr($span_class).'"></span>',
			'after_title'   => '<span class="last '.esc_attr($span_class).'"></span></h3>',
		) );			

		register_sidebar( array(
			'name'          => esc_html__( 'Footer 3', 'fitmeal' ),
			'id'            => 'footer-3',
			'description'   => esc_html__( 'Displayed in the footer section of the site.', 'fitmeal' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="header-widget '.esc_attr($header_class).'"><span class="'.esc_attr($span_class).'"></span>',
			'after_title'   => '<span class="last '.esc_attr($span_class).'"></span></h3>',
		) );			

		register_sidebar( array(
			'name'          => esc_html__( 'Footer 4', 'fitmeal' ),
			'id'            => 'footer-4',
			'description'   => esc_html__( 'Displayed in the footer section of the site.', 'fitmeal' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h3 class="header-widget '.esc_attr($header_class).'"><span class="'.esc_attr($span_class).'"></span>',
			'after_title'   => '<span class="last '.esc_attr($span_class).'"></span></h3>',
		) );			

	}
}



/**
 * Additional styles init
 */
if ( !function_exists('fitmeal_css_style') ) {

	add_action( 'wp_enqueue_scripts', 'fitmeal_css_style', 10 );
	function fitmeal_css_style() {

		global $wp_query;

		wp_enqueue_style( 'bootstrap', get_template_directory_uri() . '/assets/css/bootstrap-grid.css', array(), '1.0' );

		wp_enqueue_style( 'fitmeal-plugins', get_template_directory_uri() . '/assets/css/plugins.css', array(), wp_get_theme()->get('Version') );

		wp_enqueue_style( 'fitmeal-theme-style', get_stylesheet_uri(), array( 'bootstrap', 'fitmeal-plugins' ), wp_get_theme()->get('Version') );
	}
}


/**
 * Wp-admin styles and scripts
 */
if ( !function_exists('fitmeal_admin_init') ) {

	add_action( 'after_setup_theme', 'fitmeal_admin_init' );
	function fitmeal_admin_init() {

		add_action("admin_enqueue_scripts", 'fitmeal_admin_scripts');
	}

	function fitmeal_admin_scripts() {

		if ( function_exists('fw_get_db_settings_option') ) {

			$fontello['css'] = fw_get_db_settings_option( 'fontello-css' );
			$fontello['eot'] = fw_get_db_settings_option( 'fontello-eot' );
			$fontello['ttf'] = fw_get_db_settings_option( 'fontello-ttf' );
			$fontello['woff'] = fw_get_db_settings_option( 'fontello-woff' );
			$fontello['woff2'] = fw_get_db_settings_option( 'fontello-woff2' );
			$fontello['svg'] = fw_get_db_settings_option( 'fontello-svg' );

			if ( !empty($fontello['css']) AND !empty( $fontello['eot']) AND  !empty( $fontello['ttf']) AND  !empty( $fontello['woff']) AND  !empty( $fontello['woff2']) AND  !empty( $fontello['svg']) ) {

				wp_enqueue_style(  'fitmeal-fontello',  $fontello['css']['url'], array(), wp_get_theme()->get('Version') );

				$randomver = wp_get_theme()->get('Version');
				$css_content = "@font-face {
				font-family: 'fitmeal-fontello';
				  src: url('". esc_url ( $fontello['eot']['url']. "?" . $randomver )."');
				  src: url('". esc_url ( $fontello['eot']['url']. "?" . $randomver )."#iefix') format('embedded-opentype'),
				       url('". esc_url ( $fontello['woff2']['url']. "?" . $randomver )."') format('woff2'),
				       url('". esc_url ( $fontello['woff']['url']. "?" . $randomver )."') format('woff'),
				       url('". esc_url ( $fontello['ttf']['url']. "?" . $randomver )."') format('truetype'),
				       url('". esc_url ( $fontello['svg']['url']. "?" . $randomver )."#" . pathinfo(wp_basename( $fontello['svg']['url'] ), PATHINFO_FILENAME)  . "') format('svg');
				  font-weight: normal;
				  font-style: normal;
				}";

				wp_add_inline_style( 'fitmeal-fontello', $css_content );
			}

			wp_enqueue_script( 'fitmeal-theme-admin', get_template_directory_uri() . '/assets/js/scripts-admin.js', array( 'jquery' ) );
		}
	}
}



