<?php
/**
 * The Template for displaying all single blog posts
 */

$fitmeal_sidebar_hidden = false;
$fitmeal_sidebar = 'right';
$blog_wrap_class = 'col-xl-8 col-lg-8 col-md-12 col-xs-12';

if ( function_exists( 'FW' ) ) {

	$fitmeal_sidebar = fw_get_db_settings_option( 'blog_post_sidebar' );

	if ( $fitmeal_sidebar == 'left' ) {

		$blog_wrap_class = 'col-xl-7 col-xl-push-4 col-lg-8 col-lg-push-4 col-lg-offset-0 col-md-12 col-xs-12';	
	}
		else
	if ( $fitmeal_sidebar == 'hidden' ) {

		$blog_wrap_class = 'col-xl-9 col-lg-10 col-md-12 col-xs-12';	
		$fitmeal_sidebar_hidden = true;
	}
}

if ( !fitmeal_check_active_sidebar() ) {

	$blog_wrap_class = 'col-xl-8 col-lg-10 col-md-12 col-xs-12';	
	$fitmeal_sidebar_hidden = true;	
}

get_header();

while ( have_posts() ) : 

	the_post();

	echo '</div><header class="page-header ltx-header-narrow-wrapper">';
	    echo '<div class="container">';

			echo '<div class="ltx-narrow-header">';

				fitmeal_get_the_cats_archive();

				fitmeal_the_h1();

				fitmeal_get_the_post_headline();

			echo '</div>';	    			

	    echo '</div>';
	echo '</header><div class="container main-wrapper">';
?>
<div class="inner-page margin-post">
    <div class="row <?php if ( $fitmeal_sidebar_hidden ) echo 'row-center'; ?>">  
        <div class="<?php echo esc_attr( $blog_wrap_class ); ?>">
            <section class="blog-post">
				<?php
					get_template_part( 'tmpl/content-post-full', get_post_format() );

					if ( comments_open() || get_comments_number() ) {

						comments_template();
					}
				?>                    
            </section>
        </div>
	    <?php
	    if ( !$fitmeal_sidebar_hidden ) {

            if ( $fitmeal_sidebar == 'left' ) {

            	get_sidebar( 'left' );
            }
            	else  {

            	get_sidebar();
            }
	    }
	    ?>
    </div>
</div>
<?php

endwhile;

get_footer();
